// Old functions that aren't being deleted yet for referencing

// Read the depth map and calculate the world space position
// http://http.developer.nvidia.com/GPUGems3/gpugems3_ch27.html
float4 WorldPosFromDepth(float2 texCoords, matrix invViewProjectionMatrix) {
	// Get the depth buffer value at this pixel.  
	float zOverW = DepthStencilTex.SampleLevel(LinearSampler, texCoords, 0);
	// H is the viewport position at this pixel in the range -1 to 1.  
	float4 H = float4(texCoords.x * 2 - 1, (1 - texCoords.y) * 2 - 1, zOverW, 1);
	// Transform by the view-projection inverse.  
	float4 D = mul(H, invViewProjectionMatrix);  
	// Divide by w to get the world position.  
	float4 worldPos = D / D.w;

	return worldPos;
}

// Calculates texture-space velocity of the current pixel
// (reading from the depth buffer to reconstruct viewport space position)
float2 CalcVelocity(float2 texCoords, matrix invWVPMatrix, matrix prevWVPMatrix) {
	// Get the depth buffer value at this pixel.  
	float zOverW = DepthStencilTex.SampleLevel(LinearSampler, texCoords, 0);
	// H is the viewport position at this pixel in the range -1 to 1.  
	float4 H = float4(texCoords.x * 2 - 1, texCoords.y * 2 - 1, zOverW, 1);
	// Transform by the world-view-projection inverse.  
	float4 D = mul(H, invWVPMatrix);
	// Divide by w to get the nonhomogenous world position.  
	float4 worldPos = D / D.w;

	// Current viewport position
	float4 currentPos = H;  
	// Use the world position, and transform by the previous world-view-projection matrix.  
	float4 previousPos = mul(worldPos, prevWVPMatrix);  
	// Convert to nonhomogeneous points [-1,1] by dividing by w.  
	previousPos /= previousPos.w;  
	
	return CalcVelocity(currentPos, previousPos);
}